'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - Ultima Printers                         **/
'/**                                                                       **/
'/**  MODULE NAME  : Driver1.vb                                            **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Partial Public Class Main

#Region "=== Initialisation ==="

    Private Sub InitDriver1Tab()
        InitCorrectionCombos()
        InitSideCombos()
    End Sub

    Private sidekp As New Dictionary(Of SDK.Side, String) From
    {
        {SDK.Side.Front, "Front"},
        {SDK.Side.Back, "Back"}
    }

    Private Sub InitSideCombos()
        ResinAreaSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        ResinAreaSideCombo.DisplayMember = "Value"
        ResinAreaSideCombo.ValueMember = "Key"

        CardSettingsSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        CardSettingsSideCombo.DisplayMember = "Value"
        CardSettingsSideCombo.ValueMember = "Key"

        HoloKoteSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        HoloKoteSideCombo.DisplayMember = "Value"
        HoloKoteSideCombo.ValueMember = "Key"

        ColourAreaSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        ColourAreaSideCombo.DisplayMember = "Value"
        ColourAreaSideCombo.ValueMember = "Key"
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Local Methods ==="

    Private Sub Driver1Controls(Control As Boolean)
        If Driver1TabInit = True Then
            GUIUserCheck.Enabled = Control
            GUIPrinterCheck.Enabled = Control
            SharpnessUpDown.Enabled = Control
            CorrectionCombo.Enabled = Control
            YMCPowerUpDown.Enabled = Control
            ResinPowerUpDown.Enabled = Control
            OvercoatPowerUpDown.Enabled = Control
            ResinAreaLeftUpDown.Enabled = Control
            ResinAreaWidthUpDown.Enabled = Control
            ResinAreaBottomUpDown.Enabled = Control
            ResinAreaHeightUpDown.Enabled = Control
            ColourAreaCorrectionCombo.Enabled = Control
            ColourAreaLeftUpDown.Enabled = Control
            ColourAreaWidthUpDown.Enabled = Control
            ColourAreaBottomUpDown.Enabled = Control
            ColourAreaHeightUpDown.Enabled = Control
        End If

    End Sub

    Private Function Driver1ActionIsGet()
        Return Driver1GetRadio.Checked
    End Function

    Private Sub ClearDriver1MsgBoxButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ClearDriver1MsgBoxButton.Click
        Driver1MsgBox.Clear()
    End Sub

    Private Sub Driver1ActionGetRadio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles Driver1GetRadio.CheckedChanged
        Driver1Controls(False)
    End Sub

    Private Sub Driver1ActionSetRadio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles Driver1SetRadio.CheckedChanged
        Driver1Controls(True)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== GUI Control ==="

    Private Sub GUIControlToMsgBox(ByVal Action As SDK.Action, ByVal control As SDK.GUIControl)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("GUI User" + sep + control.User.ToString + Environment.NewLine)
        Driver1MsgBox.AppendText("GUI Printer" + sep + control.Printer.ToString + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetGUIControl(ByVal control As SDK.GUIControl)
        GUIUserCheck.Checked = control.User
        GUIPrinterCheck.Checked = control.Printer
    End Sub

    Private Function GetGUIControl(ByRef control As SDK.GUIControl) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_GUIControl(hSession, SDK.Action.Read, control)
        If SDKReturn = SDK.Return.Success Then
            SetGUIControl(control)
        Else
            HandleError("GetGUIControl", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub GUIControlButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles GUIControlButton.Click
        Dim control As SDK.GUIControl = New SDK.GUIControl

        If Driver1ActionIsGet() Then
            If GetGUIControl(control) = SDK.Return.Success Then
                GUIControlToMsgBox(SDK.Action.Read, control)
            End If
        Else
            control.User = GUIUserCheck.Checked()
            control.Printer = GUIPrinterCheck.Checked
            Dim SDKReturn As SDK.Return = SDK.ID_GUIControl(hSession, SDK.Action.Write, control)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetGUIControl", SDKReturn)
            Else
                GUIControlToMsgBox(SDK.Action.Write, control)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Sharpness ==="

    Private Function GetSharpness(ByRef sharpness As SByte) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_Sharpness(hSession, SDK.Action.Read, sharpness)
        If SDKReturn = SDK.Return.Success Then
            SetSharpness(sharpness)
        Else
            HandleError("GetSharpness", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub SharpnessToMsgBox(ByVal Action As SDK.Action, ByVal sharpness As SByte)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Sharpness" + sep + sharpness.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetSharpness(ByVal sharpness As SByte)
        SharpnessUpDown.Value = sharpness
    End Sub

    Private Sub SharpnessButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SharpnessButton.Click
        Dim sharpness As SByte = SharpnessUpDown.Value

        If Driver1ActionIsGet() Then
            If GetSharpness(sharpness) = SDK.Return.Success Then
                SharpnessToMsgBox(SDK.Action.Read, sharpness)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_Sharpness(hSession, SDK.Action.Write, sharpness)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetSharpness", SDKReturn)
            Else
                SharpnessToMsgBox(SDK.Action.Write, sharpness)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Colour Correction ==="

    Private correctionkp As New Dictionary(Of SDK.Correction, String) From
    {
        {SDK.Correction.None, "None"},
        {SDK.Correction.ICC_External, "ICC External"},
        {SDK.Correction.Perceptual, "Perceptual"},
        {SDK.Correction.Saturation, "Saturation"},
        {SDK.Correction.RelColorimetric, "Rel Colorimetric"},
        {SDK.Correction.AbsColorimetric, "Abs Colorimetric"}
    }

    Private Sub InitCorrectionCombos()
        CorrectionCombo.DataSource = New BindingSource(correctionkp, Nothing)
        CorrectionCombo.DisplayMember = "Value"
        CorrectionCombo.ValueMember = "Key"
        ColourAreaCorrectionCombo.DataSource = New BindingSource(correctionkp, Nothing)
        ColourAreaCorrectionCombo.DisplayMember = "Value"
        ColourAreaCorrectionCombo.ValueMember = "Key"
    End Sub

    Private Sub CorrectionToMsgBox(ByVal Action As SDK.Action, ByVal correction As SDK.Correction)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Colour Correction" + sep + correctionkp.Item(correction) + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetCorrection(ByVal correction As SDK.Correction)
        CorrectionCombo.Text = correctionkp.Item(correction)
    End Sub

    Private Function GetColourCorrection(ByRef correction As SDK.Correction) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_ColourCorrection(hSession, SDK.Action.Read, correction)
        If SDKReturn = SDK.Return.Success Then
            SetCorrection(correction)
        Else
            HandleError("GetColourCorrection", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub ColourCorrectionButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ColourCorrectionButton.Click
        Dim correction As SDK.Correction = New SDK.Correction

        If Driver1ActionIsGet() Then
            If GetColourCorrection(correction) = SDK.Return.Success Then
                CorrectionToMsgBox(SDK.Action.Read, correction)
            End If
        Else
            correction = CorrectionCombo.SelectedItem.Key
            Dim SDKReturn As SDK.Return = SDK.ID_ColourCorrection(hSession, SDK.Action.Write, correction)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetColourCorrection", SDKReturn)
            Else
                CorrectionToMsgBox(SDK.Action.Write, correction)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Power Levels ==="

    Private Function GetPowerLevels(ByRef Levels As SDK.PowerLevel) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_PowerLevel(hSession, SDK.Action.Read, Levels)
        If SDKReturn = SDK.Return.Success Then
            SetPowerLevels(Levels)
        Else
            HandleError("GetPowerLevel", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub PowerLevelsToMsgBox(Action As SDK.Action, PowerLevel As SDK.PowerLevel)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Power Level YMC" + sep + PowerLevel.YMC.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Power Level Resin" + sep + PowerLevel.Resin.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Power Level Overcoat" + sep + PowerLevel.Overcoat.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetPowerLevels(PowerLevel As SDK.PowerLevel)
        YMCPowerUpDown.Value = PowerLevel.YMC
        ResinPowerUpDown.Value = PowerLevel.Resin
        OvercoatPowerUpDown.Value = PowerLevel.Overcoat
    End Sub

    Private Sub PowerLevelButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles PowerLevelButton.Click
        Dim PowerLevel As New SDK.PowerLevel

        If Driver1ActionIsGet() Then
            If GetPowerLevels(PowerLevel) = SDK.Return.Success Then
                PowerLevelsToMsgBox(SDK.Action.Read, PowerLevel)
            End If
        Else
            PowerLevel.YMC = YMCPowerUpDown.Value
            PowerLevel.Resin = ResinPowerUpDown.Value
            PowerLevel.Overcoat = OvercoatPowerUpDown.Value

            Dim SDKReturn As SDK.Return = SDK.ID_PowerLevel(hSession, SDK.Action.Write, PowerLevel)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetPowerLevel", SDKReturn)
            Else
                PowerLevelsToMsgBox(SDK.Action.Write, PowerLevel)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Resin Areas ==="

    Private Sub ResinArea_Changed(sender As System.Object, e As System.EventArgs) _
                Handles ResinAreaSideCombo.SelectedIndexChanged, _
                        ResinAreaNoUpDown.ValueChanged
        If Driver1TabInit Then
            Dim Area As New SDK.Area
            Dim SDKReturn As SDK.Return = GetResinArea(ResinAreaSideCombo.SelectedItem.Key, ResinAreaNoUpDown.Value, Area)
            If SDKReturn = SDK.Return.Success Then
                SetResinArea(Area)
            End If
        End If
    End Sub

    Private Function GetResinArea(SideID As SDK.Side, AreaNo As Byte, ByRef Area As SDK.Area) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_ResinArea(hSession, SDK.Action.Read, SideID, AreaNo, Area)
        If SDKReturn = SDK.Return.Success Then
            SetResinArea(Area)
        Else
            HandleError("GetResinArea", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub ResinAreaToMsgBox(Action As SDK.Action, side As SDK.Side, area As SDK.Area)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Resin Area " + sidekp.Item(side) + " " + ResinAreaNoUpDown.Value.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Left" + sep + area.Left.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Width" + sep + area.Width.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Height" + sep + area.Height.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetResinArea(Area As SDK.Area)
        ResinAreaLeftUpDown.Value = Area.Left
        ResinAreaWidthUpDown.Value = Area.Width
        ResinAreaBottomUpDown.Value = Area.Bottom
        ResinAreaHeightUpDown.Value = Area.Height
    End Sub

    Private Sub ResinAreaButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ResinAreaButton.Click
        Dim area As New SDK.Area
        Dim side As SDK.Side = ResinAreaSideCombo.SelectedItem.Key

        If Driver1ActionIsGet() Then
            If GetResinArea(side, ResinAreaNoUpDown.Value, area) = SDK.Return.Success Then
                ResinAreaToMsgBox(SDK.Action.Read, side, area)
            End If
        Else
            area.Left = ResinAreaLeftUpDown.Value
            area.Width = ResinAreaWidthUpDown.Value
            area.Bottom = ResinAreaBottomUpDown.Value
            area.Height = ResinAreaHeightUpDown.Value

            Dim SDKReturn As SDK.Return = SDK.ID_ResinArea(hSession, _
                                                           SDK.Action.Write, _
                                                           side, _
                                                           ResinAreaNoUpDown.Value, _
                                                           area)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetResinArea", SDKReturn)
            Else
                ResinAreaToMsgBox(SDK.Action.Write, side, area)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Colour Area Settings ==="

    Private Sub ColourArea_Changed(sender As System.Object, e As System.EventArgs) _
                Handles ColourAreaSideCombo.SelectedIndexChanged
        ColourArea_Changed()
    End Sub
    Private Sub ColourAreaNo_ValueChanged(sender As System.Object, e As System.EventArgs) _
                Handles ColourAreaNo.ValueChanged
        ColourArea_Changed()
    End Sub
    Private Sub ColourArea_Changed()
        'Colour Area settings have been changed
        If Driver2TabInit Then
            Dim area As New SDK.Area
            Dim correction As New SDK.Correction
            Dim areaNo As Byte = Decimal.ToByte(ColourAreaNo.Value)

            If GetColourArea(ColourAreaSideCombo.SelectedItem.Key, areaNo, area, correction) = SDK.Return.Success Then
                SetColourArea(area, correction)
            End If
        End If

    End Sub

    Private Sub ColourAreaToMsgBox(action As SDK.Action,
                                   side As SDK.Side,
                                   areaNo As Integer,
                                   area As SDK.Area,
                                   correction As SDK.Correction)
        'Update the message box with the Resin Area settings
        Dim sep As String = Separator(action)
        Driver1MsgBox.AppendText("Colour Area " + sidekp.Item(side) + " " + areaNo.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Left" + sep + area.Left.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Width" + sep + area.Width.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Bottom" + sep + area.Bottom.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Height" + sep + area.Height.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Correction" + sep + correctionkp.Item(correction) + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetColourArea(area As SDK.Area, correction As SDK.Correction)
        'Update the Colour Area controls
        ColourAreaLeftUpDown.Value = area.Left
        ColourAreaWidthUpDown.Value = area.Width
        ColourAreaBottomUpDown.Value = area.Bottom
        ColourAreaHeightUpDown.Value = area.Height
        ColourAreaCorrectionCombo.Text = correctionkp.Item(correction)
    End Sub

    Private Function GetColourArea(side As SDK.Side,
                                   areaNo As Byte,
                                   ByRef area As SDK.Area,
                                   ByRef correction As SDK.Correction) As SDK.Return

        Dim SDKReturn As SDK.Return = SDK.ID_ColourArea(hSession, SDK.Action.Read, side, areaNo, area, correction)
        If SDKReturn = SDK.Return.Success Then
            SetColourArea(area, correction)
        Else
            HandleError("GetColourArea", SDKReturn)
        End If

        Return SDKReturn
    End Function


    Private Sub ColourAreaButton_Click(sender As System.Object, e As System.EventArgs) Handles ColourAreaButton.Click
        Dim area As New SDK.Area
        Dim areaNo As Byte = Decimal.ToByte(ColourAreaNo.Value)
        Dim side As SDK.Side = ColourAreaSideCombo.SelectedItem.Key
        Dim correction As New SDK.Correction

        If Driver1ActionIsGet() Then
            'Get the Colour Area settings
            If GetColourArea(side, areaNo, area, correction) = SDK.Return.Success Then
                ColourAreaToMsgBox(SDK.Action.Read, side, areaNo, area, correction)
            End If

        Else
            'Get the selected Colour Area settings
            area.Left = Decimal.ToInt32(ColourAreaLeftUpDown.Value)
            area.Width = Decimal.ToInt32(ColourAreaWidthUpDown.Value)
            area.Bottom = Decimal.ToInt32(ColourAreaBottomUpDown.Value)
            area.Height = Decimal.ToInt32(ColourAreaHeightUpDown.Value)
            correction = ColourAreaCorrectionCombo.SelectedItem.Key

            'Call the SDK to write to the driver
            Dim SDKReturn As SDK.Return = SDK.ID_ColourArea(hSession,
                                                            SDK.Action.Write,
                                                            side,
                                                            areaNo,
                                                            area,
                                                            correction)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetColourArea", SDKReturn)
            Else
                ColourAreaToMsgBox(SDK.Action.Write, side, areaNo, area, correction)
            End If
        End If
    End Sub

#End Region

End Class

